
  NAME OsCalls

RAM_CGROUP GROUP RAM_CODE
DGROUP GROUP DATA

PUBLIC SetRomSlot
PUBLIC SetOsCallsInterrupt

PUBLIC mySlot
PUBLIC myRomID


myRomID      EQU 0
nullSlot     EQU 0FEH
routineInRam EQU 0FFH

EXTRN xCpSetActiveSlot: FAR

EXTRN CpAllocate: FAR        ; OsAllocate : FAR
EXTRN OsFree : FAR
EXTRN CpGetSize: FAR         ; OsGetSize : FAR
EXTRN CpGetMemStatus: FAR    ; OsGetMemStatus : FAR
EXTRN xOsCreateProcess : FAR
EXTRN OsForkProcess : FAR
EXTRN CpDelay: FAR           ; OsDelay : FAR
EXTRN OsSetPriority : FAR
;EXTRN OsWhoAmI : FAR
EXTRN CpWhoAmI: FAR          ; OsWhereAmI : FAR
EXTRN OsDeleteProcess : FAR
EXTRN OsExit : FAR
EXTRN CpReceive: FAR         ; OsReceive : FAR
EXTRN OsSend : FAR
EXTRN OsCreateSemaphore : FAR
EXTRN CpWait: FAR            ; OsWait : FAR
EXTRN CpSignal: FAR          ; OsSignal : FAR
EXTRN CpDeleteSemaphore: FAR ; OsDeleteSemaphore : FAR
EXTRN xOsAttach : FAR
EXTRN xOsOpen : FAR
EXTRN OsRead : FAR
EXTRN OsWrite : FAR
EXTRN OsSeek : FAR
EXTRN xOsTruncate : FAR
EXTRN xOsFlushAllBuffers : FAR
EXTRN xOsRename : FAR
EXTRN OsChangeExtension : FAR
EXTRN xOsClose : FAR
EXTRN xOsDelete : FAR
EXTRN xOsDetach : FAR
EXTRN OsGetStatus : FAR
EXTRN OsSetStatus : FAR
EXTRN xOsGetArgument : FAR
EXTRN xOsSwitchBuffer : FAR
EXTRN xOsOverlay : FAR
EXTRN xOsGetSystemID : FAR
EXTRN CpGetTime: FAR         ; OsGetTime : FAR
EXTRN OsRegisterName : FAR
EXTRN OsLookUpName : FAR
EXTRN xOsDecodeException : FAR
EXTRN OsHandleCancel : FAR
EXTRN xOsReadDescriptor : FAR
EXTRN xOsWriteDescriptor : FAR
EXTRN OsAddKbChar : FAR
EXTRN ConKeyPressed : FAR
EXTRN ConPeekChar : FAR
EXTRN ConCharIn : FAR
EXTRN ConCharOut : FAR
EXTRN ConLineOut : FAR
EXTRN ConDefCsr : FAR
EXTRN ConMoveCsr : FAR
EXTRN ConResetDisplay : FAR
EXTRN xOsAddDevice : FAR
EXTRN xOsRemoveDevice : FAR
EXTRN OsGetProperty : FAR
EXTRN xOsPutProperty : FAR
EXTRN xOsAddAlias : FAR
EXTRN xOsDeleteAlias : FAR
EXTRN OsUnLoad : FAR
EXTRN OsVersionNumber : FAR
EXTRN xGetEntryPoint : FAR
EXTRN GetConsoleState : FAR
EXTRN xWinFrameWindow : FAR
EXTRN xWinClipLine : FAR
EXTRN xWinClipRectangle : FAR
EXTRN xWinDrawLine : FAR
EXTRN xWinEraseLine : FAR
EXTRN xWinInvertLine : FAR
EXTRN xWinSetClip : FAR
EXTRN xWinResetClip : FAR
EXTRN xWinSetWindow : FAR
EXTRN xWinInitDefaultWindow : FAR
EXTRN xWinEraseRectangle : FAR
EXTRN xWinInvertRectangle : FAR
EXTRN xWinEraseWindow : FAR
EXTRN xWinDrawPixel : FAR
EXTRN xWinErasePixel : FAR
EXTRN xWinCopyRectangle : FAR
EXTRN xWinScrollRectangle : FAR
EXTRN xWinScrollWindow : FAR
EXTRN xWinDrawChar : FAR
EXTRN xWinDrawChars : FAR
EXTRN xWinInvertChar : FAR
EXTRN xWinEraseChar : FAR
EXTRN xWinGetWindowExtent : FAR
EXTRN xWinInvertPixel : FAR
EXTRN WinSetFont : FAR
EXTRN xWinTestPixel : FAR
EXTRN WinGetCurrentWindowState : FAR
EXTRN WinLoadFont : FAR
EXTRN OsCallDriver : FAR
EXTRN OsGetPrefix : FAR
EXTRN OsGetWork : FAR
EXTRN SysdepInvalidCall : FAR
EXTRN IntSend : FAR
EXTRN OsMatchWildCard : FAR
EXTRN ConHexOut : FAR
EXTRN OsOuroBouro : FAR
EXTRN WinHandlePhone : FAR
EXTRN LineHeight : FAR
EXTRN CharHeight : FAR
EXTRN CharWidth : FAR
EXTRN BaseLine : FAR
EXTRN xOsUpdateDeviceList : FAR
EXTRN WinAllocateWindowMemory : FAR
EXTRN xWinSetAlternateWindow : FAR
EXTRN xWinCopyRemoteRectangle : FAR
EXTRN ConLineIn: FAR
EXTRN OsAddressOf: FAR
EXTRN CheckCodeEscape: FAR
EXTRN DqAllocate: FAR
EXTRN DqFree: FAR
EXTRN DqGetSize: FAR
EXTRN DqTrapCC: FAR
EXTRN DqTrapException: FAR
EXTRN DqGetExceptionHandler: FAR
EXTRN DqDecodeException: FAR
EXTRN DqGetSystemID: FAR
EXTRN DqGetTime: FAR
EXTRN DqDelete: FAR
EXTRN DqRename: FAR
EXTRN DqAttach: FAR
EXTRN DqCreate: FAR
EXTRN DqOpen: FAR
EXTRN DqSeek: FAR
EXTRN DqGetConnectionStatus: FAR
EXTRN DqChangeExtension: FAR
EXTRN DqOverlay: FAR
EXTRN DqSpecial: FAR
EXTRN DqGetArgument: FAR
EXTRN DqSwitchBuffer: FAR
EXTRN DqExit: FAR
EXTRN DqReserveIOMemory: FAR
EXTRN DqFileInfo: FAR
; EXTRN DqDecodeTime: FAR
; EXTRN DqChangeAccess: FAR
EXTRN RealBBDevice: FAR
EXTRN RealCiDevice: FAR
EXTRN RealCoDevice: FAR
EXTRN WinAddKBChar: FAR

EXTRN RedoListsPatch: FAR
EXTRN FindThisTitlePatch: FAR
$EJECT


DATA SEGMENT BYTE PUBLIC 'DATA'

EXTRN myEmsSlot: BYTE

DATA ENDS


RAM_CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:RAM_CGROUP, DS:NOTHING, ES:NOTHING


; SetRomSlot: PROCEDURE BYTE
;  This routine returns AL=FFH if the InteGRiD Rom is not there

SetRomSlot PROC FAR
  MOV  AX, DGROUP
  MOV  ES, AX
  MOV  AL, ES:myEmsSlot
  MOV  CS:mySlot, AL

  PUSH AX
  CALL xCpSetActiveSlot        ; set my rom slot
  MOV  AL, 0
  RET
SetRomSlot ENDP


; List of routines exported by the Os

routines DD CpAllocate         ; OsAllocate
         DD OsFree
         DD CpGetSize          ; OsGetSize
         DD CpGetMemStatus     ; OsGetMemStatus
         DD xOsCreateProcess
         DD OsForkProcess
         DD CpDelay            ; OsDelay
         DD OsSetPriority
         DD CpWhoAmI           ; OsWhoAmI
         DD CpWhoAmI           ; OsWhereAmI
         DD OsDeleteProcess
         DD OsExit
         DD CpReceive          ; OsReceive
         DD OsSend
         DD OsCreateSemaphore
         DD CpWait             ; OsWait
         DD CpSignal           ; OsSignal
         DD CpDeleteSemaphore  ; OsDeleteSemaphore
         DD xOsAttach
         DD xOsOpen
         DD OsRead
         DD OsWrite
         DD OsSeek
         DD xOsTruncate
         DD xOsFlushAllBuffers
         DD xOsRename
         DD OsChangeExtension
         DD xOsClose
         DD xOsDelete
         DD xOsDetach
         DD OsGetStatus
         DD OsSetStatus
         DD xOsGetArgument
         DD xOsSwitchBuffer
         DD xOsOverlay
         DD xOsGetSystemID
         DD CpGetTime          ; OsGetTime
         DD OsRegisterName
         DD OsLookUpName
         DD xOsDecodeException
         DD OsHandleCancel
         DD xOsReadDescriptor
         DD xOsWriteDescriptor
         DD OsAddKbChar
         DD ConKeyPressed
         DD ConPeekChar
         DD ConCharIn
         DD ConCharOut
         DD ConLineOut
         DD ConDefCsr
         DD ConMoveCsr
         DD ConResetDisplay
         DD xOsAddDevice
         DD xOsRemoveDevice
         DD OsGetProperty
         DD xOsPutProperty
         DD xOsAddAlias
         DD xOsDeleteAlias
         DD OsUnLoad
         DD OsVersionNumber
         DD xGetEntryPoint
         DD GetConsoleState
         DD xWinFrameWindow
         DD xWinClipLine
         DD xWinClipRectangle
         DD xWinDrawLine
         DD xWinEraseLine
         DD xWinInvertLine
         DD xWinSetClip
         DD xWinResetClip
         DD xWinSetWindow
         DD xWinInitDefaultWindow
         DD xWinEraseRectangle
         DD xWinInvertRectangle
         DD xWinEraseWindow
         DD xWinDrawPixel
         DD xWinErasePixel
         DD xWinCopyRectangle
         DD xWinScrollRectangle
         DD xWinScrollWindow
         DD xWinDrawChar
         DD xWinDrawChars
         DD xWinInvertChar
         DD xWinEraseChar
         DD xWinGetWindowExtent
         DD xWinInvertPixel
         DD WinSetFont
         DD xWinTestPixel
         DD WinGetCurrentWindowState
         DD WinLoadFont
         DD OsCallDriver
         DD OsGetPrefix
         DD OsGetWork
         DD IntSend
         DD SysdepInvalidCall    ;OsGetCardStatus
         DD SysdepInvalidCall    ;OsCreateRemoteProcess
         DD SysdepInvalidCall    ;OsLogError
         DD OsMatchWildCard 
         DD ConHexOut
         DD OsOuroBouro
         DD WinHandlePhone
         DD LineHeight
         DD CharHeight
         DD CharWidth
         DD BaseLine
         DD SysdepInvalidCall    ;ConDecimalOut
         DD xOsUpdateDeviceList
         DD WinAllocateWindowMemory
         DD xWinSetAlternateWindow
         DD xWinCopyRemoteRectangle
         DD ConLineIn
         DD OsAddressOf
        
         DD CheckCodeEscape        
         DD DqAllocate             ; 0
         DD DqFree                 ; 1
         DD DqGetSize              ; 2
         DD DqTrapCC               ; 3
         DD DqTrapException        ; 4
         DD DqGetExceptionHandler  ; 5
         DD DqDecodeException      ; 6
         DD DqGetSystemID          ; 7
         DD DqGetTime              ; 8
         DD DqDelete               ; 9
         DD DqRename               ; a
         DD DqAttach               ; b
         DD DqCreate               ; c
         DD DqOpen                 ; d
         DD xOsClose               ; e
         DD xOsDetach              ; f
         DD OsRead                 ; 10
         DD OsWrite                ; 11
         DD DqSeek                 ; 12
         DD xOsTruncate            ; 13
         DD DqGetConnectionStatus  ; 14
         DD DqChangeExtension      ; 15
         DD DqOverlay              ; 16
         DD DqSpecial              ; 17
         DD DqGetArgument          ; 18
         DD DqSwitchBuffer         ; 19
         DD DqExit                 ; 1a
         DD DqFileInfo             ; 1b
         DD DqReserveIOMemory      ; 1c
         DD DqFileInfo             ; DqDecodeTime 1d
         DD DqFileInfo             ; DqChangeAccess 1e

         DD RealBBDevice
         DD RealCiDevice
         DD RealCoDevice
         DD WinAddKBChar

         DD RedoListsPatch
         DD FindThisTitlePatch

; List of # words of parms for each call...  gross

parms    DB routineInRam         ; 3 - OsAllocate
         DB 4                    ; OsFree
         DB routineInRam         ; 4 - OsGetSize
         DB routineInRam         ; 5 - OsGetMemStatus
         DB 6                    ; xOsCreateProcess
         DB routineInRam         ; OsForkProcess
         DB routineInRam         ; 1 - OsDelay
         DB 4                    ; OsSetPriority
         DB routineInRam         ; 0 - OsWhoAmI
         DB routineInRam         ; 0 - OsWhereAmI
         DB 3                    ; OsDeleteProcess
         DB 1                    ; OsExit
         DB routineInRam         ; 7 - OsReceive
         DB 7                    ; OsSend
         DB 2                    ; OsCreateSemaphore
         DB routineInRam         ; 4 - OsWait
         DB routineInRam         ; 5 - OsSignal
         DB routineInRam         ; 3 - OsDeleteSemaphore
         DB 8                    ; xOsAttach
         DB 4                    ; xOsOpen
         DB 6                    ; OsRead
         DB 6                    ; OsWrite
         DB 6                    ; OsSeek
         DB 3                    ; xOsTruncate
         DB 3                    ; xOsFlushAllBuffers
         DB 5                    ; xOsRename
         DB 7                    ; OsChangeExtension
         DB 3                    ; xOsClose
         DB 3                    ; xOsDelete
         DB 3                    ; xOsDetach
         DB 6                    ; OsGetStatus
         DB 6                    ; OsSetStatus
         DB 3                    ; xOsGetArgument
         DB 2                    ; xOsSwitchBuffer
         DB 5                    ; xOsOverlay
         DB 2                    ; xOsGetSystemID
         DB 3                    ; OsGetTime
         DB 7                    ; OsRegisterName
         DB 4                    ; OsLookUpName
         DB 3                    ; xOsDecodeException
         DB 1                    ; OsHandleCancel
         DB 5                    ; xOsReadDescriptor
         DB 5                    ; xOsWriteDescriptor
         DB 1                    ; OsAddKbChar
         DB 0                    ; ConKeyPressed
         DB 0                    ; ConPeekChar
         DB 0                    ; ConCharIn
         DB 1                    ; ConCharOut
         DB 3                    ; ConLineOut
         DB 1                    ; ConDefCsr
         DB 2                    ; ConMoveCsr
         DB 0                    ; ConResetDisplay
         DB 11                   ; xOsAddDevice
         DB 4                    ; xOsRemoveDevice
         DB 7                    ; OsGetProperty
         DB 6                    ; xOsPutProperty
         DB 8                    ; xOsAddAlias
         DB 4                    ; xOsDeleteAlias
         DB 4                    ; OsUnLoad
         DB 5                    ; OsVersionNumber
         DB 5                    ; xGetEntryPoint
         DB 0                    ; GetConsoleState
         DB 0                    ; xWinFrameWindow
         DB routineInRam         ; 8 - xWinClipLine
         DB routineInRam         ; 2 - xWinClipRectangle
         DB routineInRam         ; 4 - xWinDrawLine
         DB routineInRam         ; 4 - xWinEraseLine
         DB routineInRam         ; 4 - xWinInvertLine
         DB routineInRam         ; 2 - xWinSetClip
         DB routineInRam         ; 0 - xWinResetClip
         DB 2                    ; xWinSetWindow
         DB 0                    ; xWinInitDefaultWindow
         DB routineInRam         ; 2 - xWinEraseRectangle
         DB routineInRam         ; 2 - xWinInvertRectangle
         DB routineInRam         ; 0 - xWinEraseWindow
         DB routineInRam         ; 2 - xWinDrawPixel
         DB routineInRam         ; 2 - xWinErasePixel
         DB routineInRam         ; 4 - xWinCopyRectangle
         DB routineInRam         ; 4 - xWinScrollRectangle
         DB routineInRam         ; 4 - xWinScrollWindow
         DB routineInRam         ; 3 - xWinDrawChar
         DB routineInRam         ; 5 - xWinDrawChars
         DB routineInRam         ; 2 - xWinInvertChar
         DB routineInRam         ; 2 - xWinEraseChar
         DB routineInRam         ; 2 - xWinGetWindowExtent
         DB routineInRam         ; 2 - xWinInvertPixel
         DB 5                    ; WinSetFont
         DB routineInRam         ; 2 - xWinTestPixel
         DB 0                    ; WinGetCurrentWindowState
         DB 3                    ; WinLoadFont
         DB 8                    ; OsCallDriver
         DB 0                    ; OsGetPrefix
         DB 0                    ; OsGetWork
         DB 8                    ; IntSend
         DB 0                    ; InvalidCall - OsGetCardStatus
         DB 0                    ; InvalidCall - OsCreateRemoteProcess
         DB 0                    ; InvalidCall - OsLogError
         DB 10                   ; OsMatchWildCard 
         DB 1                    ; ConHexOut
         DB 5                    ; OsOuroBouro
         DB 5                    ; WinHandlePhone
         DB routineInRam         ; 0 - LineHeight
         DB routineInRam         ; 0 - CharHeight
         DB routineInRam         ; 0 - CharWidth
         DB routineInRam         ; 0 - BaseLine
         DB 0                    ; InvalidCall - ConDecimalOut
         DB 0                    ; xOsUpdateDeviceList
         DB 5                    ; WinAllocateWindowMemory
         DB routineInRam         ; 2 - xWinSetAlternateWindow
         DB routineInRam         ; 9 - xWinCopyRemoteRectangle
         DB 3                    ; ConLineIn
         DB 1                    ; OsAddressOf
         DB 0                    ; CheckCodeEscape        
         DB 3                    ; DqAllocate - 0
         DB 3                    ; DqFree - 1
         DB 3                    ; DqGetSize - 2
         DB 4                    ; DqTrapCC - 3
         DB 4                    ; DqTrapException - 4
         DB 4                    ; DqGetExceptionHandler - 5
         DB 5                    ; DqDecodeException - 6
         DB 4                    ; DqGetSystemID - 7
         DB 4                    ; DqGetTime - 8
         DB 4                    ; DqDelete - 9
         DB 6                    ; DqRename - a
         DB 4                    ; DqAttach - b
         DB 4                    ; DqCreate - c
         DB 5                    ; DqOpen - d
         DB 3                    ; xOsClose - e
         DB 3                    ; xOsDetach - f
         DB 6                    ; OsRead - 10
         DB 6                    ; OsWrite - 11
         DB 6                    ; DqSeek - 12
         DB 3                    ; xOsTruncate - 13
         DB 5                    ; DqGetConnectionStatus - 14
         DB 6                    ; DqChangeExtension - 15
         DB 4                    ; DqOverlay - 16
         DB 5                    ; DqSpecial - 17
         DB 4                    ; DqGetArgument - 18
         DB 4                    ; DqSwitchBuffer - 19
         DB 1                    ; DqExit - 1a
         DB 6                    ; DqFileInfo - 1b
         DB 4                    ; DqReserveIOMemory - 1c
         DB 6                    ; DqDecodeTime - 1d
         DB 6                    ; DqChangeAccess - 1e
         DB 5                    ; RealBBDevice
         DB 5                    ; RealCiDevice
         DB 5                    ; RealCoDevice
         DB 3                    ; WinAddKBChar

         DB 0                    ; RedoListsPatch
         DB 4                    ; FindThisTitlePatch

mySlot   DB ?                    ; current Rom Slot
$EJECT

IntrEntry LABEL NEAR
  JMP  SHORT InterruptEntry
  JMP  SHORT IndrEntry

; info on jump table

jumpTable:
  DW   routines
  DW   RAM_CGROUP
parmTable:
  DW   parms
  DW   RAM_CGROUP
numCalls:
  DB   150                       ; # calls in this interrupt

IndrEntry:
  MOV  BX, AX
  LES  DI, DWORD PTR parmTable
  MOV  CL, BYTE PTR ES:[DI+BX] 
  CMP  CL, routineInRam
  JNZ  RomIndr
  JMP  RamRoutine

RomIndr:
  PUSH AX                        ; save call #
  PUSH CX                        ; save parm count
  MOV  AL, RAM_CGROUP:mySlot     ; store mySlot using CS override
  XOR  AH, AH
  PUSH AX
  CALL xCpSetActiveSlot          ; old slot in AX
  POP  CX                        ; parm count
  POP  BX                        ; restore call #

  POP  DX                        ; get IP
  POP  ES                        ; get CS
  JMP  SHORT IndirectEntry

InterruptEntry:
  POP  BX                        ; get IP
  POP  ES                        ; get CS
  POPF                           ; set flags

  MOV  DL, BYTE PTR ES:[BX]	     ; get call #
  XOR  DH, DH
  INC  BX                        ; skip past call
  XCHG DX, BX      
  MOV  AX, ES
                                 ; AX = returnCS
                                 ; BX = call #
                                 ; DX = returnIP


  LES  DI, DWORD PTR parmTable
  MOV  CL, BYTE PTR ES:[DI+BX] 
  CMP  CL, routineInRam
  JNZ  RomIntr
  PUSH AX                        ; restore returnCS
  PUSH DX                        ; restore returnIP
  JMP  RamRoutine

RomIntr:
  PUSH AX                        ; save return CS
  PUSH DX                        ; save return IP
  PUSH BX                        ; save call #
  PUSH CX                        ; save parm count
  MOV  AL, RAM_CGROUP:mySlot
  XOR  AH, AH
  PUSH AX
  CALL xCpSetActiveSlot     

  POP  CX                        ; get parm count
  POP  BX                        ; get call #
  POP  DX                        ; get IP
  POP  ES                        ; get CS

IndirectEntry:
  MOV  DI, DS      
                                 ; AX = old slot #
                                 ; BX = call #
                                 ; CL = parm count
                                 ; DX = return IP
                                 ; ES = return CS
                                 ; DI = old DS

  MOV  CH, BH                    ; zero the upper byte of parm count
  MOV  BH, AL                    ; store old slot in BH

                                 ; BL = call #
                   ; BH = old slot #
                   ; CX = # words of parms
                   ; DX = return IP
                   ; ES = return CS
                   ; DI = old DS


  JCXZ SHORT NoParms ; test if move is required
  MOV  AX, ES      ; save old CS
  MOV  SI, SS
  MOV  ES, SI
  MOV  DS, SI

  MOV  SI, SP
  SUB  SP, 8       ; move parms down by 8
                   ;  The new stack will be like:
                   ;     parms
                   ;     old slot #
                   ;     old DS
                   ;     caller's IP
                   ;     caller's CS
  PUSH BP
  MOV  BP, DI
  MOV  DI, SP
  ADD  DI, 2

                   ; AX = return CS
                   ; BL = call #
                   ; BH = old slot #
                   ; CX = # words of parms
                   ; DX = return IP
                   ; ES = SS
                   ; DS = SS
                   ; SI = old location of parms
                   ; DI = new location of parms
                   ; BP = old DS

  CLD
  REP  MOVSW

  MOV  DS:[SI-2], AX  ;restore CS
  MOV  DS:[SI-4], DX  ;restore IP
  MOV  DS:[SI-6], BP  ;restore DS
  POP  BP

  MOV  AL, BH
  XOR  AH, AH
  MOV  BH, AH
  MOV  DS:[SI-8], AX  ;old slot #

AddExtraInfo:
  MOV  AX, DGROUP
  MOV  DS, AX         ; set my DS Register
  CMP  BL, BYTE PTR numCalls
  JB   LookInTable

  CALL SysdepInvalidCall    ; routine not in table - abort

LookInTable:
  SHL  BX, 1          
  SHL  BX, 1          ; table is 4 bytes per entry
  LES  DI, DWORD PTR jumpTable  ; get the jump table
  JMP  SHORT MakeTheCall

NoParms:
  PUSH ES          ; restore CS
  PUSH DX          ; restore IP
  PUSH DI          ; restore DS
  MOV  AL, BH
  XOR  AH, AH
  MOV  BH, AH
  PUSH AX  ;old slot #
                   ;  The new stack will be like:
                   ;     old slot #
                   ;     old DS
                   ;     caller's IP
                   ;     caller's CS
  JMP AddExtraInfo

MakeTheCall:
  CALL DWORD PTR ES:[DI+BX]     ; go to the routine
  POP  CX          ; old slot #
  PUSH AX
  PUSH BX
  PUSH DX
  PUSH ES

  PUSH CX                 ; setup for call to setslot
  CALL xCpSetActiveSlot    ; reset the slot
  POP  ES
  POP  DX          ; restore all regs
  POP  BX
  POP  AX
  POP  DS          ; restore DS reg

LongReturnAgain PROC FAR
  RET
LongReturnAgain ENDP


RamRoutine:
  SHL  BX, 1          ; BX = call #
  SHL  BX, 1          ; table is 4 bytes per entry
  LES  DI, DWORD PTR jumpTable  ; get the jump table
  JMP  DWORD PTR ES:[DI+BX]
$EJECT

SetOsCallsInterrupt PROC FAR
  XOR  AX, AX
  MOV  ES, AX

  CLI

  MOV  AX, 4 * 112
  MOV  BX, AX

  MOV  AX, SEG IntrEntry                ; Store InteGRiD's Int 70h Rtn Base
  MOV  ES:[BX+2], AX                    ; into segment part of Int 70

  MOV  AX, OFFSET RAM_CODE:IntrEntry    ; Store InteGRiD's Int 70h Rtn Offset
  MOV  ES:[BX+0], AX                    ; into offset part of Int 70

  STI
  RET
SetOsCallsInterrupt ENDP


RAM_CODE ENDS

  END
